<style>
    th, td { 
        white-space: nowrap; 
    }
    div.dataTables_wrapper {
        margin: 0 auto;
    }
</style>
<table id="list_data" class="table table-striped table-bordered" style="width:100%">
    <thead>
        <tr class="bg-tr">
            <th class="text-center">NO</th>
            <th class="text-center">NIK</th>
            <th class="text-center" valign="middle">NAMA KARYAWAN</th>
            <th class="text-center">GELAR DEPAN</th>
            <th class="text-center">GELAR BELAKANG</th>
            <th class="text-center" >JABATAN</th>
            <th class="text-center" >CABANG</th>
            <th class="text-center" >DEPARTEMEN</th>
            <th class="text-center" >STATUS</th>
            <th class="text-center" >TANGGAL AKTIF BEKERJA</th>
            <th class="text-center" >TANGGAL BERHENTI BEKERJA</th>
            <th class="text-center" >USERNAME</th>
            <th class="text-center" >SALDO CUTI</th>
            <th class="text-center" >JENIS KELAMIN</th>
            <th class="text-center" >TEMPAT LAHIR</th>
            <th class="text-center" >TANGGAL LAHIR</th>
            <th class="text-center" >ALAMAT</th>
            <th class="text-center" >AGAMA</th>
            <th class="text-center" >TELEPON</th>
            <th class="text-center" >EMAIL</th>
            <th class="text-center" >Nomor Induk Kependudukan</th>
            <th class="text-center" >AKSI</th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>

<script type="text/javascript">
    $(function() {
        list_data = $('#list_data').DataTable({ 
                'searching'     : true,
                'paging'        : true,
                'lengthChange'  : true,
                'ordering'      : true,
                'info'          : true,
                'scrollX'       :true,
                'scrollCollapse': true,
                'fixedColumns'  :{
                    'leftColumns': 3,
                },
                    'language'    :{
                                    'url'         : '<?=base_url("assets/plugins/datatables/dataTables-language-id.json")?>',
                                    'sEmptyTable' : 'Tidak ada data untuk ditampilkan',
                                    'searchPlaceholder': 'NIK/Nama Karyawan'
                                },
                    "processing"  : true, 
                    "serverSide"  : true, 
                    "order"       : [], 
                    
                    "ajax"        : {
                                    "url": "<?= route('karyawan.import.listdata') ?>",
                                    "type": "POST",
                                    "complete" : function(data){
                                                    reconfigure(data);
                                                }
                                    },
            
                    "aoColumnDefs": [
                                        { "aTargets": [0], "bSortable": false},
                                        { "aTargets": [1], "bSortable": true},
                                        { "aTargets": [2], "bSortable": true},
                                        { "aTargets": [3], "bSortable": false},
                                        { "aTargets": [4], "bSortable": false},
                                        { "aTargets": [5], "bSortable": false},
                                        { "aTargets": [6], "bSortable": false},
                                        { "aTargets": [7], "bSortable": false},
                                        { "aTargets": [8], "bSortable": false},
                                        { "aTargets": [9], "bSortable": false},
                                        { "aTargets": [10], "bSortable": false},
                                        { "aTargets": [11], "bSortable": false},
                                        { "aTargets": [12], "bSortable": false},
                                        { "aTargets": [13], "bSortable": false},
                                        { "aTargets": [14], "bSortable": false},
                                        { "aTargets": [15], "bSortable": false},
                                        { "aTargets": [16], "bSortable": false},
                                        { "aTargets": [17], "bSortable": false},
                                        { "aTargets": [18], "bSortable": false},
                                        { "aTargets": [19], "bSortable": false},
                                        { "aTargets": [20], "bSortable": false},
                                        { "aTargets": [-1], "bSortable": false}

                                    ],
                    "fnRowCallback": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {

                            $('td:eq(0)', nRow).css({'text-align':'center'});
                    },
        });
    });
</script>